package easik.ui.menu;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import easik.Easik;


/**
 * The menu action for when 'new sketch' is selected
 * 
 * @author Rob Fletcher 2005
 */

public class FileNewAction extends AbstractAction {	
	/**
	 * Create a new sketch action option.	 
	 */
	public FileNewAction() {
		super("New Sketch");
		putValue(AbstractAction.MNEMONIC_KEY, new Integer(KeyEvent.VK_N));
		putValue(AbstractAction.SHORT_DESCRIPTION, "Start new sketch");		
	}

	/**
	 * Create a new sketch.  Prompts user for confirmation if current sketch is unsaved.
	 * 
	 * @param e The Action Event
	 */
	public void actionPerformed(ActionEvent e) {
		int n = 0;
		if (Easik.getInstance().getFrame().getSketch().getDirty()) {
			n =
				JOptionPane.showConfirmDialog(
					Easik.getInstance().getFrame(),
					"Unsaved changes will be lost, continue anyway?",
					"Caution!",
					JOptionPane.YES_NO_OPTION);			
		}
		if (n == 0) {
			Easik.getInstance().getFrame().getSketch().newSketch();						
		}
	}
}
